<?php
   /*
    *  Change Merak Password plugin 0.7
    *
    */

   chdir ('..');
   if (!defined('SM_PATH')) define('SM_PATH','../');

   // include compatibility plugin
   //
   if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');

   // get global variables for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_POST_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_POST = $HTTP_POST_VARS;
   }

   global $color;
   global $merak_url, $merak_selfpage, $merak_action, $use_ssl_for_password_change, $debug;

   if (compatibility_check_sm_version(1, 3))
   {
      include_once (SM_PATH . 'include/validate.php');
      include_once (SM_PATH . 'functions/page_header.php');
      include_once (SM_PATH . 'functions/imap.php');
      include_once (SM_PATH . 'include/load_prefs.php');
      include_once (SM_PATH . 'functions/i18n.php');
      include_once (SM_PATH . 'config/config.php');
      include_once (SM_PATH . 'functions/strings.php');
      include_once (SM_PATH . 'functions/imap.php');

      global $use_ssl_for_password_change;
      include_once (SM_PATH . 'plugins/change_merakpass/config.php');
   }
   else
   {
      include_once ('../src/validate.php');
      include_once ('../functions/page_header.php');
      include_once ('../functions/imap.php');
      include_once ('../src/load_prefs.php');
      include_once ('../functions/i18n.php');
      include_once ('../config/config.php');
      include_once ('../functions/strings.php');
      include_once ('../functions/imap.php');

      global $use_ssl_for_password_change;
      include_once ('../plugins/change_merakpass/config.php');
   }

   // get flag that tells us if this is a password submission attempt...
   //
   if (isset($_POST['plugin_change_merakpass']))
      $plugin_change_merakpass = $_POST['plugin_change_merakpass'];

   // make sure this page is encrypted so passwords can't be sniffed
   // (only if flag is on)
   //
   if ($use_ssl_for_password_change) {
      if (!isset($_SERVER['HTTPS'])) {

         $location = 'https://' . $_SERVER['HTTP_HOST']
            . $_SERVER['REQUEST_URI'];

         header("Location: $location");
         exit(0);

      }
   }

   // determine URL for redirection if Cancel is pressed
   // (non https if the flag is on, otherwise, use what
   // was already there)
   //
   if (!$use_ssl_for_password_change)
       $cancelLocation = 'http' . (isset($_SERVER["HTTPS"]) ? 's' : '');
   else
       $cancelLocation = 'http';

   ereg("(^.*/).*", $_SERVER['REQUEST_URI'], $regs);
   $cancelLocation .= '://' . $_SERVER['HTTP_HOST']
      . $regs[1] . '../../src/options.php?optmode=submit&plugin_change_merakpass=0';

   // if a password change is given, check its validity
   //
   if (isset($plugin_change_merakpass))
   {
       $Messages = change_merakpass_check();

       // the above only returns if password wasn't changed
       // so if we came from webmail.php, must redirect to
       // right_main.php (need to pass messages along...)
       //
       if (stristr($_SERVER['PHP_SELF'], 'webmail.php'))
       {
          $location = $_SERVER['PHP_SELF'];
          $location = str_replace('webmail.php', 'right_main.php', $location);
          $location .= '?messages=';
          foreach($Messages as $message) $location .= urlencode($message . '||');

          header('Location: ' . $location);
          exit(0);
       }
   }

   // don't display page header if we got a successful
   // password change (No error messages exist and a
   // password was submitted.  Cannot send output before
   // header() call)
   //
   if (!isset($Messages) && isset($cp_oldpass) && $cp_oldpass)
   {
      // do nothing
   }
   else
   {
      displayPageHeader($color, 'None', 'document.forms[0].elements["cp_oldpass"].focus();');

      echo '<table width=95% align=center cellpadding=2 cellspacing=2 border=0>';
      echo '<tr><td bgcolor="';

      echo $color[0] . '">';
   }

   bindtextdomain('change_merakpass', '../plugins/change_merakpass/locale');
   textdomain('change_merakpass');

   echo '<center><b>';
   echo _("Options - Change Password"); if ($use_ssl_for_password_change) echo ' - ' . _("Secure");
   echo '</b></center></td>';

   textdomain('squirrelmail');

if (isset($Messages) && count($Messages)) {
    echo "<tr><td>\n";
    foreach ($Messages as $line) {
        echo htmlspecialchars($line) . "<br>\n";
    }
    echo "</td></tr>\n";
}

?><tr><td>
<?php

	if ($_SERVER['PHP_SELF']) {
		$location=$_SERVER['PHP_SELF'];
	} else {
		$location="../plugins/change_merakpass/options.php";
	}

   $location = str_replace('right_main.php', 'webmail.php', $location);

   bindtextdomain('change_merakpass', '../plugins/change_merakpass/locale');
   textdomain('change_merakpass');

?>
    <form method=post action="<?php echo $location; ?>">
    <table>
      <tr>
        <th align=right><?php echo _("Old Password"); ?>:</th>
        <td><input type=password name=cp_oldpass value=""  size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("New Password"); ?>:</th>
        <td><input type=password name=cp_newpass value="" size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("Verify New Password"); ?>:</th>
        <td><input type=password name=cp_verify value="" size=20></td>
      </tr>
      <tr>
        <td align=right colspan=2>
          <input type="hidden" name="plugin_change_merakpass" value="1">
          <input type=submit value="<?php echo _("Submit"); ?>">
<?php

   echo '<input type=button value="' . _("Cancel") . '" onClick="document.location=\'' . $cancelLocation . '\'"'
        . ' name="plugin_change_merakpass_cancel">';

   textdomain('squirrelmail');

?>
        </td>
      </tr>
    </table>
</td></tr>
</tr></table>
</body></html>
<?php

exit(0);

function change_merakpass_check() {
   global $cp_oldpass, $cp_newpass, $cp_verify, $key, $onetimepad;
   global $plugin_change_ldappass;


   // get global variables for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SESSION_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS;
      $_SESSION = $HTTP_SESSION_VARS;
      $_POST = $HTTP_POST_VARS;
      $_COOKIE = $HTTP_COOKIE_VARS;
   }


   $Messages = array();
   $password = OneTimePadDecrypt($_COOKIE['key'], $_SESSION['onetimepad']);

   $cp_oldpass = $_POST['cp_oldpass'];
   $cp_newpass = $_POST['cp_newpass'];
   $cp_verify = $_POST['cp_verify'];

   bindtextdomain('change_merakpass', '../plugins/change_merakpass/locale');
   textdomain('change_merakpass');

   if ($cp_oldpass == '')
       array_push($Messages, _("You must type in your old password."));
   if ($cp_newpass == '')
       array_push($Messages, _("You must type in a new password."));
   if ($cp_verify == '')
       array_push($Messages,
           _("You must also type in your new password in the verify box."));
   if ($cp_newpass != '' && $cp_verify != $cp_newpass)
       array_push($Messages,
           _("Your new password does not match the verify password."));
   if ($cp_oldpass != '' && $cp_oldpass != $password)
       array_push($Messages, _("Your old password is not correct."));
   if ($cp_oldpass == $cp_newpass)
       array_push($Messages, _("Your new password must be different than your old password."));

   textdomain('squirrelmail');

   if (count($Messages))
       return $Messages;

   return change_merakpass_go($password);
}

function change_merakpass_go($password) {

   global $merak_url, $merak_selfpage, $merak_action, $use_ssl_for_password_change, $debug;

    // get global variables for versions of PHP < 4.1
    //
    if (!compatibility_check_php_version(4, 1)) {
       global $HTTP_SESSION_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_SERVER_VARS;
       $_SESSION = $HTTP_SESSION_VARS;
       $_SERVER = $HTTP_SERVER_VARS;
       $_POST = $HTTP_POST_VARS;
       $_COOKIE = $HTTP_COOKIE_VARS;
    }

    if (file_exists("../plugins/change_merakpass/config.php"))
    include_once ('../plugins/change_merakpass/config.php');
    if (file_exists("./plugins/change_merakpass/config.php"))
    include_once ('./plugins/change_merakpass/config.php');

    $Messages = array();

    $cp_newpass = $_POST['cp_newpass'];
    $cp_oldpass = $_POST['cp_oldpass'];

    $username = $_SESSION['username'];
    $base_uri = $_SESSION['base_uri'];
    $onetimepad = $_SESSION['onetimepad'];
    $key = $_COOKIE['key'];

    $user = $username;
    if ($split_username_query)
    {
        list($user, $domain) = preg_split('/' . $split_username_expression . '/', $username);
    }

      $url = $merak_url . $merak_selfpage;

      $ch = curl_init();
      curl_setopt ($ch, CURLOPT_URL, $url);
      curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt ($ch, CURLOPT_TIMEOUT, 10);
      curl_setopt ($ch, CURLOPT_USERPWD, "$username:$cp_oldpass");
      curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, 1);
      $result = curl_exec ($ch);
      curl_close ($ch);

      if (strpos($result, "401 Access denied") <> 0) {
         bindtextdomain('change_merakpass', '../plugins/change_merakpass/locale');
         textdomain('change_merakpass');
         array_push($Messages, _("Cannot change password! (401)"));
         textdomain('squirrelmail');

         return $Messages;
      }

      // Get URL from: <FORM METHOD="POST" ACTION="success.html?id=a9375ee5e445775e871d5e1401a963aa">

      $str = $result;
      $str = stristr($str, "<FORM");
      $str = substr($str, 0, strpos($str, ">") + 1);
      $str = stristr($str, "ACTION=");
      $str = substr(stristr($str, "\""),1);
      $str = substr($str, 0, strpos($str, "\""));
      $newurl = $merak_url . $str;

      // Get useraddr from: $useraddr = <INPUT TYPE="HIDDEN" NAME="usraddr" VALUE="edwin@l-eve-software.com">

      $str = $result;
      $str = stristr($str, "usraddr");
      $str = substr($str, 0, strpos($str, ">") + 1);
      $str = stristr($str, "VALUE=");
      $str = substr(stristr($str, "\""),1);
      $str = substr($str, 0, strpos($str, "\""));
      $useraddr = $str;

      //Include (almost) all input fields from screen

      $contents2 = $result;

      $tag = stristr($contents2, "<INPUT");

      while ($tag) {

         $contents2 = stristr($contents2, "<INPUT");
         $tag = substr($contents2, 0, strpos($contents2, ">") + 1);

         if (GetSub($tag, "TYPE") == "TEXT" ||
             GetSub($tag, "TYPE") == "HIDDEN" ||
             GetSub($tag, "TYPE") == "PASSWORD") {
            $tags[GetSub($tag, "NAME")] = GetSub($tag, "VALUE");
         }

         if ((GetSub($tag, "TYPE") == "RADIO" ||
              GetSub($tag, "TYPE") == "CHECKBOX") &&
             IsChecked($tag)) {
            $tags[GetSub($tag, "NAME")] = GetSub($tag, "VALUE");
         }

         $contents2 = substr($contents2, 1);

      }

      $tags["action"] = $merak_action;
      $tags["usraddr"] = $useraddr;
      $tags["usr_pass"] = $cp_newpass;
      $tags["usr_conf"] = $cp_newpass;

      $str2 = "";
      foreach ($tags as $key => $value) {
         $str2 .= $key . "=" . urlencode($value) . "&";
      }

      $str2 = trim($str2, "&");

      // Change password!

      $ch = curl_init();
      curl_setopt ($ch, CURLOPT_URL, $newurl);
      curl_setopt ($ch, CURLOPT_POST, 1);
      curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, 1);
      curl_setopt ($ch, CURLOPT_POSTFIELDS, $str2);
      $result=curl_exec ($ch);
      curl_close ($ch);

      if (strpos($result, "Failure") <> 0) {
         bindtextdomain('change_merakpass', '../plugins/change_merakpass/locale');
         textdomain('change_merakpass');
         array_push($Messages, _("Cannot change password! (Failure)"));
         textdomain('squirrelmail');

         return $Messages;
      }

      // Write new cookies for the password
      $onetimepad = OneTimePadCreate(strlen($cp_newpass));
      $_SESSION['onetimepad'] = $onetimepad;
      $key = OneTimePadEncrypt($cp_newpass, $onetimepad);
      setcookie('key', $key, 0, $base_uri);

        // Automatically forward back to the options screen if correct
        if ($debug == 0) {

           // no longer using https:
           // (unless the flag is off, in which case we don't care - just
           // use what was already there)
           //
           if (!$use_ssl_for_password_change)
               $location = 'http' . (isset($_SERVER["HTTPS"]) ? 's' : '');
           else
               $location = 'http';

           ereg("(^.*/).*", $_SERVER['REQUEST_URI'], $regs);
           $location .= '://' . $_SERVER['HTTP_HOST'];

           if (strstr($_SERVER['REQUEST_URI'], 'right_main.php')
            || strstr($_SERVER['REQUEST_URI'], 'webmail.php'))
              $location .= $regs[1] . 'right_main.php?optmode=submit&plugin_change_merakpass=1';
           else
              $location .= $regs[1] . '../../src/options.php?optmode=submit&plugin_change_merakpass=1';

           header("Location: $location");
           exit(0);

        }
        return $Messages;
}

function GetSub($tag, $type) {

   $str = stristr($tag, $type . "=");

   $str = substr($str, strlen($type) + 1);
   $str = trim($str, '"');

   if (!strpos($str, " ") === false) {
      $str = substr($str, 0, strpos($str, " "));
      $str = trim($str, '"');
   }

   if (!(strpos($str, '"') === false)) {
      $str = substr($str, 0, strpos($str, '"'));
   }

   $str = trim($str, '>');
// $str = strtoupper($str);

   return $str;
}

function IsChecked($tag) {

   if (!(strpos(strtolower($tag), 'checked') === false)) {
      return true;
   }

   return false;
}

?>
